package com.ws;

import java.net.URL;
import java.util.List;
import javax.jws.WebParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import util.XML;
import com.ws.CLNVerify;
import javax.xml.ws.Service;

public class CLEAN_AddressClient {
	
	public static void main(String[] args) {
		
		long   customerID               = 1;
		long   departmentID             = 2;
		String password                 = "password";
    	String SERVICE_TARGET_NAMESPACE = "http://webservice.clean-address.com/CLNVerify/";   
    	String SERVICE_NAME             = "CLNBatch"; 		
		URL    url                      = com.ws.CLEAN_AddressClient.class.getResource("/com/ws/CLEAN_Address.wsdl");
		QName  qname                    = new QName(SERVICE_TARGET_NAMESPACE, SERVICE_NAME);
		
		/*
		 * 1. Create service, and port objects
		 */
		Service      service = Service.create(url,qname);
		CLNBatchSoap port    = service.getPort(CLNBatchSoap.class);
		/*
		 * 2. Instantiate service, and port objects using runtime
		 *    parameters
		 */
		try {
			// Specify port at runtime
			BindingProvider bp = (BindingProvider) port;
			// Set runtime connection parameters
			bp.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,"http://localhost:8097" + "/" + "CLNVerify");
		} catch (Exception e) {
			System.out.println("Service Connection Error...\n" + e.toString());
			return;
		}
		/*
		 * 3. Set authentication credentials
		 * 
		 */
		Authentication authentication = new Authentication();
		try {
			authentication.setCustomerID(customerID);
		} catch (Exception e) {
			;// Do something
		}
		
		try {
			authentication.setDepartmentID(departmentID);
		} catch (Exception e) {
			;// Do something
		}
		authentication.setPassword(password);
		/*
		 * 4. Set address verification parameters
		 * 
		 */
		Parameters parameters = new Parameters();
		parameters.setVerifyAddress(true);
		parameters.setGeoCodeAddress(false);
		parameters.setCheckTelephone(false);
		parameters.setParseName(false);
		parameters.setParseEmail(false);
		parameters.setDNSCheckEmail(false);
		parameters.setUseGenericAddressLines(false);
		parameters.setGenericAddressLines(0);
		parameters.setFullNameInAddress(false);
		parameters.setCompanyNameInAddress(false);
		parameters.setCountryReturnType(CountryReturnType.fromValue("ISO_2"));
		parameters.setPreferredLanguage(PreferredLanguageType.fromValue("DEFAULT"));
		parameters.setErrorSuggestCount(5);
		parameters.setVerboseSuggestList(false);
		parameters.setMaxCityLength(0);
		parameters.setMaxProvinceLength(0);
		parameters.setMaxAddressLineLength(0);
		parameters.setExpandStreetSuffix(false);
		parameters.setExpandSingleDirectional(false);
		parameters.setExpandDoubleDirectional(false);
		parameters.setSuiteLineBeforeStreet(false);
		parameters.setAppendSuiteToStreet(false);
		parameters.setOutputAddressWithCompanyNameAttention(false);
		parameters.setAlwaysStandardize(false);
		parameters.setAlwaysUpperCase(false);
		parameters.setBasicAddressSearch(false);
		parameters.setPhoneNumberOutputFormat("");
		/*
		 * 5. Create address object to be verified
		 * 
		 */
		AddressIn addressIn = new AddressIn();
		addressIn.setRecordID("");
		addressIn.setAddressLine1("");
		addressIn.setAddressLine2("");
		addressIn.setAddressLine3("");
		addressIn.setAddressLine4("");
		addressIn.setCompany("Runner Technologies, Inc.");
		addressIn.setAttention("");
		addressIn.setAddress("6001 broken sound #620");
		addressIn.setSuite("");
		addressIn.setCity("Boca Raton");
		addressIn.setUrbanization("");
		addressIn.setState("");
		addressIn.setProvince("");
		addressIn.setPostalCode("33432");
		addressIn.setPostalCodeExtended("");
		addressIn.setLastLine("");
		addressIn.setCountryCode("USA");
		addressIn.setCountryName("");
		addressIn.setFullName("");
		addressIn.setFirstName("");
		addressIn.setMiddleName("");
		addressIn.setLastName("");
		addressIn.setNamePrefix("");
		addressIn.setNameSuffix("");
		addressIn.setPhoneNumber("");
		addressIn.setEmailAddress("");
		ArrayOfAddressIn arrayOfAddressIn = new ArrayOfAddressIn();
		arrayOfAddressIn.getAddressIn().add(addressIn);

		/*
		 * 5. Construct request object
		 *    
		 *    Note: you will need to RTI CLNVerify.java class
		 */
		CLNVerify request = new CLNVerify();
		request.setAddressCount(arrayOfAddressIn.getAddressIn().size());
		request.setAuthentication(authentication);
		request.setCampaignID(XML.xmlGetCampaignID());
		request.setAddressesIn(arrayOfAddressIn);
		request.setParameters(parameters);

		/*
		 * 6. Instantiate and populate holders for user defined and
		 *    complex data types
		 */
		Holder<String> campaign_id = new Holder<String>(request.getCampaignID());
		Holder<Long> error_code = new Holder<Long>();
		Holder<String> error_message = new Holder<String>();
		Holder<Long> result_count = new Holder<Long>();
		Holder<ArrayOfAddressOut> array_of_address_out = new Holder<ArrayOfAddressOut>();

		/*
		 * 6. Invoke service operation 
		 * 
		 */
		port.clnVerify(request.getAuthentication()
				       , new Holder<String>(  request.getCampaignID())
				       						, request.getParameters()
				       						, request.getAddressCount()
				       						, request.getAddressesIn()
				       						, error_code
				       						, error_message
				       						, result_count
				       						, array_of_address_out
				       	);

		/*
		 * 7. Process error codes, messages and results counts
		 * 
		 */
		System.out.println("error_code [" + error_code.value + "]");
		System.out.println("error_message [" + error_message.value + "]");
		System.out.println("result_count [" + result_count.value + "]\n");

		ArrayOfAddressOut retval = array_of_address_out.value;
		List<AddressOut> addressOut_list = retval.getAddressOut();
		
		/*
		 * 8. Process verified address response
		 * 
		 */
		for (AddressOut addressOut : addressOut_list) {
			System.out.println("Address: [ \n" + addressOut.toString() + " \n]");
		}
	}

}
